﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.BL.Interface;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodCertificatesIndex : BaseAPIMethod
        {

            public MethodCertificatesIndex(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "certificatesindex"; }
            }

            protected override bool DoValidate()
            {
                return true;
            }

            protected override void DoReadRequestParams()
            {
                // tutaj nic nie czytamy z sesji
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    List<GCertificate> _certificateList = Component.BLELearning.APIMobile.GetCertificates(User, Component.Environment.Domain);
                    if (_certificateList != null)
                    {
                        StatusCode = StatusCodeType.OK;
                        return new GResponseData_CertificatesIndex() { Certificates = _certificateList, count = _certificateList.Count };
                    }
                    else
                    {
                        AddErrorMessage("Nie znaleziono certyfikatów dla ucznia.");
                        StatusCode = StatusCodeType.NotFound;
                    }
                }
                return null;
            }
        }
    }
}